// GpMDoc.cpp : CGpMDoc Class source code
//

#include "stdafx.h"
#include "defsfile.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif





/////////////////////////////////////////////////////////////////////////////
// CGpMDoc


IMPLEMENT_DYNCREATE(CGpMDoc, CDocument)


BEGIN_MESSAGE_MAP(CGpMDoc, CDocument)
	//{{AFX_MSG_MAP(CGpMDoc)
	ON_COMMAND(ID_EDIT_UNDO, OnEditUndo)
	ON_COMMAND(ID_ALL_CLEAR, OnAllClear)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CGpMDoc Construction / extinction of the class

CGpMDoc::CGpMDoc()
{	
	m_szIPAddress = _T("");
	m_bConnected = FALSE ;
    m_ContentsArry.SetSize(0,64);

	m_szGP.cx = 320 ;
	m_szGP.cy = 240 ;
}

CGpMDoc::~CGpMDoc()
{
	if( m_bConnected ){
		CloseMtoM();
		m_bConnected = FALSE ;
	}
}

/////////////////////////////////////////////////////////////////////////////
// CGpMDoc diagnose a class

#ifdef _DEBUG
void CGpMDoc::AssertValid() const
{
	CDocument::AssertValid();
}

void CGpMDoc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CGpMDoc Serialize
//
void CGpMDoc::Serialize(CArchive& ar)
{

	CObject::Serialize(ar);
	m_ContentsArry.Serialize(ar);
}


/////////////////////////////////////////////////////////////////////////////
// CGpMDoc Command

//
//	Delete the pool of drawing
//
void CGpMDoc::DeleteContents()
{
    int nCount = GetContentsCount() ;

    if (nCount) {
        for (int i=0; i<nCount; i++){
            delete m_ContentsArry[i];
		}
        m_ContentsArry.RemoveAll();
    }
}

void CGpMDoc::OnEditUndo()
{
    int nCount = GetContentsCount() ;
    if (nCount) {

		delete m_ContentsArry[nCount-1];
		m_ContentsArry.RemoveAt(nCount-1);

		//	Redraw the Screen on GP
		Agreeto() ;

		//	Update the view
		UpdateAllViews(NULL);
	} else {
		MessageBeep(MB_ICONEXCLAMATION);
	}
}



//
//	Add the content to the pool
//
void CGpMDoc::AddContents(CContents  *pContents)
{
	m_ContentsArry.Add(pContents);
}

//
//	Get contents from the pool
//
CContents* CGpMDoc::GetContents(int nIndex)
{
    return((CContents*) m_ContentsArry[nIndex]);
}

//
//	Get the count of the item in the pool
//
int CGpMDoc::GetContentsCount()
{
    return(m_ContentsArry.GetSize());
}




BOOL CGpMDoc::OnNewDocument()
{

	if (!CDocument::OnNewDocument())
		return FALSE;

	if( !LinkMSock(theApp.m_szOpenDocmentIPAddress)){
		return FALSE;
	}

	Agreeto();
	return TRUE;
}

BOOL CGpMDoc::OnOpenDocument(LPCTSTR lpszPathName) 
{
	if (!CDocument::OnOpenDocument(lpszPathName))
		return FALSE;
	
	if( !LinkMSock(theApp.m_szOpenDocmentIPAddress)){
		return FALSE;
	}

	Agreeto();
	return TRUE;
}

//
//	Link the Socket
//	If IP address is decide, connect to node, if not ask to user.
//
BOOL CGpMDoc::LinkMSock(LPCSTR szIPAddress)
{
	static CString szInputIpAddress = _T("") ;

	//	check already connected
	if( m_bConnected ){
		//	chcek re-connect
		CReLinkDialog DlgReLink ;
		if( DlgReLink.DoModal() != IDOK ){
			return( TRUE );	// Don't have to re-connect
		}

		//	Disconnect
		CloseMtoM();
		m_bConnected = FALSE ;
	}
	
	int iError ;
	int iConnect = 0 ;
	MtoMSioConfig stSio ;
	if( szIPAddress == NULL ){

		CInputIPAddress DlgIP ;
		DlgIP.m_szIPAddress = szInputIpAddress ;
		if( DlgIP.DoModal() != IDOK ){
			return(FALSE) ;
		}
		iConnect = DlgIP.m_iConnect ;
		szInputIpAddress = m_szIPAddress = DlgIP.m_szIPAddress ;
		stSio = DlgIP.m_stSioConfig ;
		m_szGP.cx = (int)DlgIP.m_uiWidth ;
		m_szGP.cy = (int)DlgIP.m_wHeight ;
	} else {
		m_szIPAddress = szIPAddress ;
	}

	if( (iConnect==0) && (!m_szIPAddress.IsEmpty()) )
	{
		//	Ether
		if(iError = OpenMtoMLAN(m_szIPAddress)){
			// Cannot connect
			ErrorBox(IDS_CANTCONNECTED,(LPCSTR )m_szIPAddress,iError,MtoMGetLastError()) ;
		} else {
			//	OK
			m_bConnected = TRUE ;
	
			//	change the title of document
			SetTitle(m_szTitle);
			return( TRUE );
		}
	}
	else if( iConnect==1 )
	{
		//	SIO
		//	change the title of document
		m_szIPAddress.Format( _T("COM%d"), stSio.stMemPortConfig.byPort ) ;	
		if(iError = OpenMtoMSio(&stSio)){
			//	connect Error
			ErrorBox(IDS_CANTCONNECTED,(LPCSTR )m_szIPAddress,iError,MtoMGetLastError()) ;
		} else {
			// OK
			m_bConnected = TRUE ;

			SetTitle(m_szTitle);
			return( TRUE );
		}
	}

	m_szIPAddress = "Disconnect" ;

	// 	change the title of document
	SetTitle(m_szTitle);
	return( TRUE );
}


//
// Set the title
//
void CGpMDoc::SetTitle(LPCTSTR lpszTitle) 
{
	CString szTitle ;

	m_szTitle = lpszTitle ;	// keep the title

	szTitle = m_szIPAddress + "/"  + lpszTitle ;
	CDocument::SetTitle((LPCTSTR) szTitle );
}



//
//	Get CMemSock
//
CMemSock* CGpMDoc::GetCMemSock()
{
	if( theApp.m_TargetGP_1ToN ){
		//	1:N -> use theAPP
		return( theApp.GetBradCMemSock() );
	} else {
		//	1:1 -> use document
		return( (m_bConnected) ? this : NULL );
	}
}



//
//	Transmit all of the date to GP
//
void CGpMDoc::Agreeto()
{
	CMemSock* pCMemSock = GetCMemSock();
	int iError;

	if( pCMemSock ){
		//	delete the screen -> draw rectangle
//		if( iError = pCMSock->MtoMESC_S(0,0,0,0,GP_SCREEN_X-1,GP_SCREEN_Y-1,0) ){
		if( iError = pCMemSock->MtoMESC_S(0,0,0,0,m_szGP.cx-1,m_szGP.cy-1,0) ){
			DispMtoMError( iError ,pCMemSock->MtoMGetLastError() ) ;
			return ;
		}
		
	    int nCount = GetContentsCount();
		for (int i=0; i<nCount; i++){
 			if( iError = GetContents(i)->Transition( pCMemSock) ){
				DispMtoMError( iError,pCMemSock->MtoMGetLastError() ) ;
				return ;
			}
		}
    }
}





//
//	Event Function
//
void CGpMDoc::OnEventFunc(int iCode,DWORD dwParam1,DWORD dwParam2)
{
	CString wk ;
	switch( iCode ){
		case MTOM_CONTINUE:				//	Now Continue
			break ;

		case MTOM_EVENT_TOUCH:  		//  Touch Event
			wk.Format(IDS_MTOM_EVENT_TOUCH,dwParam1); 
			AfxMessageBox((LPCTSTR)wk) ;
			break ;

		case MTOM_EVENT_CLOSED:   		//  Disconnected
			AfxMessageBox(IDS_CLOSED) ;		
			break ;
	}
}

//	Serch the docunet that linked with IP address
// 
//  return XX:Document NULL:None
//
CGpMDoc *GetIPAddressLinkedDocument(LPCTSTR szIPaddress)
{
	CDocTemplate* pDocT ;
	POSITION  DocTPos = theApp.GetFirstDocTemplatePosition() ;
	if( pDocT = theApp.GetNextDocTemplate( DocTPos ) ){
		CGpMDoc *pDoc ;
		for( POSITION DocPos = pDocT->GetFirstDocPosition() ; (DocPos != 0) && (pDoc = (CGpMDoc *)pDocT->GetNextDoc( DocPos )) ; ){
			if( pDoc->m_bConnected ){
				// ̃hLgƂfoNĂ邩ǂ
				if( pDoc->m_szIPAddress == szIPaddress ){
					return( pDoc ) ;
				}
			}
		}
	}
	return( NULL );
}


// Deletet all of the Data.
void CGpMDoc::OnAllClear() 
{
	//	Delete the contents
	DeleteContents() ;

	//	Delete the GP Screen
	Agreeto() ;

	//	Update the view
	UpdateAllViews(NULL);
}

//
// Show the Error
//
void DispMtoMError( int iError ,DWORD dwParticulars)
{
	ErrorBox(IDS_DISPMTOMERROR,iError, dwParticulars);
}


//
// Show the warning message box
//
void ErrorBox(DWORD IDS,... )
{
	CString fmt ;
	fmt.LoadString(IDS);
	char *pfmt ;
	pfmt = (char *)((LPCSTR)fmt);

	char buf[256] ;
	va_list marker ;

	va_start(marker,IDS) ;
	vsprintf(buf,pfmt,marker) ;
	va_end(marker) ;

	AfxMessageBox(buf) ;
}
